<?php
namespace Overdose\Sales\Plugin\Helper;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Sales\Api\OrderRepositoryInterface;
use Magento\Sales\Helper\Reorder;
use Magento\Store\Model\ScopeInterface;

/**
 * Class ReorderPlugin
 * @package Overdose\Sales\Plugin\Helper
 */
class ReorderPlugin
{
    const XML_PATH_SALES_REORDER_MIN_ORDER_ID_ALLOW = 'sales/reorder/min_allow_order_id';
    /**
     * @var ScopeConfigInterface
     */
    private $scopeConfig;
    /**
     * @var OrderRepositoryInterface
     */
    private $orderRepository;

    /**
     * ReorderPlugin constructor.
     * @param ScopeConfigInterface $scopeConfig
     * @param OrderRepositoryInterface $orderRepository
     */
    public function __construct(ScopeConfigInterface $scopeConfig, OrderRepositoryInterface $orderRepository)
    {
        $this->scopeConfig = $scopeConfig;
        $this->orderRepository = $orderRepository;
    }

    /**
     * @param Reorder $subject
     * @param callable $proceed
     * @param $orderId
     * @return bool
     */
    public function aroundCanReorder(Reorder $subject, callable $proceed, $orderId)
    {
        $result = $proceed($orderId);
        if ($result) {
            $order = $this->orderRepository->get($orderId);
            $minOrderIdAllow = (int) $this->scopeConfig->getValue(
                self::XML_PATH_SALES_REORDER_MIN_ORDER_ID_ALLOW,
                ScopeInterface::SCOPE_STORE
            );
            if ($order && $order->getEntityId() > $minOrderIdAllow) {
                return $result;
            } else {
                return false;
            }
        }
        return $result;
    }
}
