<?php
namespace Overdose\Quote\Controller\Adminhtml\Order;

class Create extends \Magento\Backend\App\Action
{
    protected $resultPageFactory = false;

    /**
     * @var CartManagementInterface
     */
    protected $cartManagement;

    /**
     * Create constructor.
     * @param Context $context
     * @param PageFactory $resultPageFactory
     * @param CartManagementInterface $cartManagement
     */
    public function __construct(
        \Magento\Backend\App\Action\Context $context,
        \Magento\Framework\View\Result\PageFactory $resultPageFactory,
        \Magento\Quote\Api\CartManagementInterface $cartManagement
    )
    {
        parent::__construct($context);
        $this->cartManagement = $cartManagement;
        $this->resultPageFactory = $resultPageFactory;
    }

    public function execute() {
        $quote_id = $this->getRequest()->getParam('id');
        if(!$quote_id) {
            $this->messageManager->addErrorMessage('No Such Quote.');
            return $this->_redirect('overdose_quote/quote/index', ['_secure' => true]);
        }

        try{
            $orderId = $this->cartManagement->placeOrder($quote_id);
            $this->messageManager->addSuccessMessage('Order Creation Successful: '.$orderId);
            return $this->_redirect('sales/order/index', ['_secure' => true]);

        } catch (\Exception $e) {
             $this->messageManager->addErrorMessage('Order Creation Failed: ');
             $this->messageManager->addExceptionMessage($e, $e->getMessage());
        }

        return $this->_redirect('overdose_quote/quote/index', ['_secure' => true]);
    }

    /**
     * @return boolean
     */
    protected function _isAllowed() {
        return true;
    }
}
