<?php

namespace Overdose\MultiSelectSwatch\Setup\Patch\Data;

use Magento\Framework\Setup\Patch\DataPatchInterface;
use Magento\Framework\Setup\Patch\PatchRevertableInterface;
use Magento\Catalog\Model\Product;

class CreateProductAttributeFeature implements DataPatchInterface, PatchRevertableInterface
{
    protected $moduleDataSetup;
    protected $eavSetupFactory;
    protected $eavConfig;

    public function __construct(
        \Magento\Framework\Setup\ModuleDataSetupInterface $moduleDataSetup,
        \Magento\Eav\Setup\EavSetupFactory $eavSetupFactory,
        \Magento\Eav\Model\Config $eavConfig
    ) {
        $this->moduleDataSetup = $moduleDataSetup;
        $this->eavSetupFactory = $eavSetupFactory;
        $this->eavConfig = $eavConfig;
    }

    public function apply()
    {
        /** @var \Magento\Eav\Setup\EavSetup $eavSetup */
        $eavSetup = $this->eavSetupFactory->create(['setup' => $this->moduleDataSetup]);
        $eavSetup->addAttribute(
        Product::ENTITY,
        'features',
        [
            'type'    => 'varchar', // <---
            'label'   => 'Features',
            'input'   => 'multiselect',
            'group'   => 'General',
            'global'  => \Magento\Eav\Model\Entity\Attribute\ScopedAttributeInterface::SCOPE_GLOBAL,
            'backend' => \Magento\Eav\Model\Entity\Attribute\Backend\ArrayBackend::class,
            'required'                => false,
            'used_in_product_listing' => true,
            'visible_on_front'        => true,
            'user_defined'            => true,
            'filterable'              => false,
            'filterable_in_search'    => false,
            'used_for_promo_rules'    => false,
            'is_html_allowed_on_front' => false,
            'used_for_sort_by'        => false
        ]);
    }

    /**
     * {@inheritdoc}
     */
    public static function getDependencies()
    {
        return [];
    }

    /**
     * {@inheritdoc}
     */
    public function getAliases()
    {
        return [];
    }

    public function revert() {}
}
