<?php

namespace Overdose\MultiSelectSwatch\Helper;

use Magento\Framework\App\Http\Context as AuthContext;
use Magento\Catalog\Helper\Output;
use Magento\Swatches\Helper\Media;
use Magento\Swatches\Model\ResourceModel\Swatch\CollectionFactory;

class Data extends \Magento\Framework\App\Helper\AbstractHelper
{

    /**
     * @var catalogHelper
     */
    protected $catalogHelper;

    /**
     * @var swatchHelper
     */
    protected $swatchHelper;

        /**
     * @var swatchHelper
     */
    protected $swatchCollectionFactory;

    public function __construct(
        Output $catalogHelper,
        Media $swatchHelper,
        CollectionFactory $swatchCollectionFactory,
        \Magento\Framework\App\Helper\Context $context
    ) {
        $this->catalogHelper = $catalogHelper;
        $this->swatchHelper = $swatchHelper;
        $this->swatchCollectionFactory = $swatchCollectionFactory;
        parent::__construct($context);
    }

    public function fetchProductFeatures($product) {

        $features = $this->catalogHelper->productAttribute($product, $product->getData('features'), 'features');
        $features = explode(',', $features);
        $swatchCollection = $this->swatchCollectionFactory->create()->addFieldtoFilter('option_id', ['in' => $features]);
        $images = [];
        foreach ($swatchCollection as $item) {
            $images[] = $this->swatchHelper->getSwatchMediaUrl() . $item->getValue();
        }
        return $images;
    }
}
