<?php
/**
 * @author: Muhammad Shahbaz
 * @email: shahbaz.sial@overdose.digital
 */
namespace Overdose\LazyLoadJavascript\Plugin;

use Magento\Framework\App\Request\Http;
use Magento\Framework\Controller\ResultInterface;
use Magento\Framework\App\Response\Http as ResponseHttp;
use Magento\Framework\View\Result\Layout;
use Pharse;

class ControllerRenderResultAfter
{

    /**
     * @var Http
     */
    protected  $request;

    public function __construct(
        Http $request
    ) {
        $this->request = $request;
    }
    /**
     * FPC will be called on afterRenderResult
     *
     * @param ResultInterface $subject
     * @param \Closure $proceed
     * @param ResponseHttp $response
     * @return Layout
     */
    public function aroundRenderResult(
        ResultInterface $subject,
        \Closure $proceed,
        ResponseHttp $response
    ) {
        $result = $proceed($response);

        try {
            $currentActionName = $this->request->getFullActionName();
            if(($currentActionName == "cms_index_index" ||
                $currentActionName == "catalog_category_view" ||
                $currentActionName == "catalog_product_view")
            )
            {
                $html = Pharse::str_get_dom($response->getBody());
                foreach ($html('link') as $link) {
                    $linkSrc = $link->getAttribute('href');
                    if(//strpos(strtolower($linkSrc), "_cache/merged") !== false ||
                        strpos(strtolower($linkSrc), "print.min.css") !== false ||
                        strpos(strtolower($linkSrc), "styles-l.min.css") !== false ||
                        strpos(strtolower($linkSrc), "afterpay.min.css") !== false
                    ){
                        $link->setAttribute('rel', 'preload');
                        $link->setAttribute('as', 'style');
                        $link->setAttribute('onload', "this.rel='stylesheet'");
                    }
                }
                foreach ($html('iframe') as $iframe) {
                    $iframe_src = $iframe->getAttribute('src');
                    if(strpos(strtolower($iframe_src), "googletagmanager") === false){
                        $iframe->deleteAttribute('src');
                        $iframe->setAttribute('data-src', $iframe_src);
                    }
                }
                foreach ($html('script') as $element) {
                    $script_content = $element->getInnerText();
                    $script_src = $element->getAttribute('src');
                    if ($script_content && (strpos(strtolower($script_content), "require.config") !== false ||
                        strpos(strtolower($script_content), "require(") !== false ||
                        strpos(strtolower($script_content), "require (") !== false ||
                        strpos(strtolower($script_content), "requirejs(") !== false ||
                        strpos(strtolower($script_content), "js.klevu.com") !== false ||
                        strpos(strtolower($script_content), "connect.facebook.net") !== false ||
                        strpos(strtolower($script_content), "www.googletagmanager.com") !== false ||
                        strpos(strtolower($script_content), "www.googleadservices.com") !== false ||
                        strpos(strtolower($script_content), "s.go-mpulse.net") !== false ||
                        strpos(strtolower($script_content), "js-agent.newrelic.com") !== false ||
                        strpos(strtolower($script_content), "bam.nr-data.net") !== false ||
                        strpos(strtolower($script_content), "zR_Dm5") !== false ||
                        strpos(strtolower($script_content), "cdn.livechatinc.com") !== false||
                        strpos(strtolower($script_content), "lazyload.js") !== false ||
                        strpos(strtolower($script_content), "lazyload.min.js") !== false ||
                        strpos(strtolower($script_content), "klevu_cms") !== false ||
                        strpos(strtolower($script_content), "klevu_uc") !== false ||
                        strpos(strtolower($script_content), "klaviyo_form_trigger") !== false ||
                        strpos(strtolower($script_content), "staticimpressions") !== false ||
                        strpos(strtolower($script_content), "prodimagecontainers") !== false ||
                        strpos(strtolower($script_content), "catalogupdate") !== false ||
                        strpos(strtolower($script_content), "cookie-status") !== false
                        )) {
                        $element->setAttribute('type', 'text/delayscript');
                    }
                    if ($script_src && (strpos(strtolower($script_src), '-resolver.') !== false||
                        strpos(strtolower($script_src), 'requirejs/require') !== false ||
                        strpos(strtolower($script_src), 'requirejs/mixins') !== false ||
                        strpos(strtolower($script_src), '/requirejs-config.') !== false ||
                        strpos(strtolower($script_src), 'mage/polyfill') !== false)) {
                        $element->setAttribute('type', 'loaderscripts');
                    }
                    if($script_src && (strpos(strtolower($script_src), "static.klaviyo.com") !== false ||
                        strpos(strtolower($script_src), "apps.bazaarvoice.com") !== false ||
                        strpos(strtolower($script_src), "api.bazaarvoice.com") !== false ||
                        strpos(strtolower($script_src), "cdn.livechatinc.com") !== false ||
                        strpos(strtolower($script_src), "www.youtube.com") !== false ||
                        strpos(strtolower($script_src), "s.go-mpulse.net") !== false ||
                        strpos(strtolower($script_src), "connect.facebook.net") !== false ||
                        strpos(strtolower($script_src), "afterpay-products.js") !== false ||
                        strpos(strtolower($script_src), "afterpay-products.min.js") !== false ||
                        strpos(strtolower($script_src), "www.googletagmanager.com") !== false ||
                        strpos(strtolower($script_src), "lazyload.js") !== false ||
                        strpos(strtolower($script_src), "stripe_payments.min.js") !== false ||
                        strpos(strtolower($script_src), "stripe_payments.js") !== false ||
                        strpos(strtolower($script_src), "lazyload.min.js") !== false
                    )){
                        $element->setAttribute('type', 'text/delayscriptsource');
                    }
                }
                $response->setBody($html->__toString());
            }
        } catch (\Exception $e) {
        }
        return $result;
    }
}
