<?php

namespace Overdose\InventoryShipping\Model\ResourceModel\Order;

use Magento\Framework\Event\ManagerInterface as EventManager;
use Magento\Framework\Model\AbstractModel;
use Magento\Framework\Model\ResourceModel\Db\Context;
use Magento\Framework\Model\ResourceModel\Db\VersionControl\RelationComposite;
use Magento\Framework\Model\ResourceModel\Db\VersionControl\Snapshot;
use Magento\Sales\Model\ResourceModel\Attribute;
use Magento\SalesSequence\Model\Manager;

/**
 * Override core Invoice class to add custom after_save event
 */
class Invoice extends \Magento\Sales\Model\ResourceModel\Order\Invoice
{
    /**
     * @var EventManager
     */
    private EventManager $eventManager;

    /**
     * Invoice constructor.
     * @param Context $context
     * @param Snapshot $entitySnapshot
     * @param RelationComposite $entityRelationComposite
     * @param Attribute $attribute
     * @param Manager $sequenceManager
     * @param EventManager $eventManager
     * @param null $connectionName
     */
    public function __construct(
        Context $context,
        Snapshot $entitySnapshot,
        RelationComposite $entityRelationComposite,
        Attribute $attribute,
        Manager $sequenceManager,
        EventManager $eventManager,
        $connectionName = null
    ) {
        parent::__construct($context, $entitySnapshot, $entityRelationComposite, $attribute, $sequenceManager, $connectionName);
        $this->eventManager = $eventManager;
    }

    /**
     * @inheritDoc
     */
    protected function _afterSave(AbstractModel $object)
    {
        $this->eventManager->dispatch('od_invoice_resource_after_save', ['invoice' => $object]);
        return parent::_afterSave($object);
    }
}
