define([
    'underscore',
    'mage/utils/wrapper',
    'ko',
    'Magento_Checkout/js/model/checkout-data-resolver'
], function (_, wrapper, ko, checkoutDataResolver) {
    'use strict';
    var shippingRates = ko.observableArray([]);

    return function (shippingService) {
        return _.extend(checkoutDataResolver, {
            isLoading: ko.observable(false),

            /**
             * Set shipping rates
             *
             * @param {*} ratesData
             */
            setShippingRates: function (ratesData) {
                for (var i = 0; i < ratesData.length; i++) {
                    if (ratesData[i] && ratesData[i].carrier_code == 'instore') {
                        if (!(window.checkoutConfig.overdoseInStorePickup && window.checkoutConfig.overdoseInStorePickup.is_available_method)) {
                            ratesData[i].carrier_title = ratesData[i].carrier_title + ' (Unavailable)';
                        }
                    }
                }
                shippingRates(ratesData);
                shippingRates.valueHasMutated();
                checkoutDataResolver.resolveShippingRates(ratesData);
            },

            /**
             * Get shipping rates
             *
             * @returns {*}
             */
            getShippingRates: function () {
                return shippingRates;
            }
        });
    }
});
