<?php

namespace Overdose\InStorePickup\Plugin\Model\ResourceModel\Product\Type;

use Magento\ConfigurableProduct\Model\ResourceModel\Attribute\OptionProvider;
use Magento\Eav\Model\Entity\Attribute\AbstractAttribute;

class Configurable
{
    /**
     * @var OptionProvider
     */
    private $optionProvider;

    /**
     * @param OptionProvider $optionProvider
     */
    public function __construct(OptionProvider $optionProvider)
    {
        $this->optionProvider = $optionProvider;
    }

    /**
     * @param $subject
     * @param callable $proceed
     * @param $product
     * @param $attributes
     * @return array
     */
    public function aroundGetConfigurableOptions($subject, callable $proceed, $product, $attributes)
    {
        $result = $proceed($product, $attributes);
        if ($product->getUseForPopupStockAvibility()) {
            $attributesOptionsData = [];
            $productId = $product->getData($this->optionProvider->getProductEntityLinkField());
            foreach ($attributes as $superAttribute) {
                $attributeId = $superAttribute->getAttributeId();
                $superAttribute->setUseForPopupStockAvibility(true);
                $attributesOptionsData[$attributeId] = $subject->getAttributeOptions($superAttribute, $productId);
            }
            return $attributesOptionsData;
        }
        return $result;
    }

}
