<?php

namespace Overdose\InStorePickup\Plugin\Block\Checkout;

use Magento\Checkout\Model\Session;
use Magento\Framework\Stdlib\ArrayManager;
use Magento\InventoryInStorePickupFrontend\Block\Checkout\LayoutProcessor;
use Magento\InventoryInStorePickupShippingApi\Model\IsInStorePickupDeliveryAvailableForCartInterface;

class LayoutProcessorPlugin
{
    /**
     * @var ArrayManager
     */
    protected $arrayManager;

    /**
     * @var Session
     */
    protected $checkoutSession;

    /**
     * @var IsInStorePickupDeliveryAvailableForCartInterface
     */
    protected $inStorePickupDeliveryAvailableForCart;

    /**
     * Construct function
     *
     * @param ArrayManager $arrayManager
     * @param Session $session
     * @param IsInStorePickupDeliveryAvailableForCartInterface $inStorePickupDeliveryAvailableForCart
     */
    public function __construct(
        ArrayManager $arrayManager,
        Session $session,
        IsInStorePickupDeliveryAvailableForCartInterface $inStorePickupDeliveryAvailableForCart
    ) {
        $this->arrayManager = $arrayManager;
        $this->checkoutSession = $session;
        $this->inStorePickupDeliveryAvailableForCart = $inStorePickupDeliveryAvailableForCart;
    }

    /**
     * Process plugin function
     *
     * @param LayoutProcessor $subject
     * @param mixed $result
     * @param array $jsLayout
     * @return mixed
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function afterProcess(
        LayoutProcessor $subject,
        $result,
        array $jsLayout
    ) {
        if (!$this->inStorePickupDeliveryAvailableForCart->execute((int)$this->checkoutSession->getQuoteId())) {
            $result = $this->removeCustomStorePickup($result);
        }
        return $result;
    }

    /**
     * Remove custom store pickup ui components from layout.
     *
     * @param array $jsLayout
     *
     * @return array
     */
    protected function removeCustomStorePickup(array $jsLayout): array
    {
        $storePickupPath = $this->arrayManager->findPath('shipping-faux-store-selector', $jsLayout);
        $jsLayout = $this->arrayManager->remove($storePickupPath, $jsLayout);

        return $jsLayout;
    }
}
