<?php
namespace Overdose\GiftCardAccountApi\Model\Service;

use Magento\Framework\Api\DataObjectHelper;
use Magento\Framework\Api\ExtensionAttribute\JoinProcessorInterface;
use Magento\Framework\Api\SearchCriteriaBuilder;
use Magento\Framework\EntityManager\EntityManager;
use Magento\Framework\Exception\CouldNotSaveException;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\Exception\ValidatorException;
use Magento\Framework\Reflection\DataObjectProcessor;
use Magento\GiftCardAccount\Model\Giftcardaccount;
use Magento\GiftCardAccount\Model\GiftcardaccountFactory;
use Magento\GiftCardAccount\Api\Data\GiftCardAccountInterface;
use Overdose\GiftCardAccountApi\Model\GiftCardAccount as OGCA;
use Overdose\GiftCardAccountApi\Model\GiftCardAccountFactory as OGCAF;
use Overdose\GiftCardAccountApi\Api\Data\GiftCardAccountInterface as OGCAI;
use Overdose\GiftCardAccountApi\Api\Data\GiftCardAccountInterfaceFactory as OGCAIF;
use Magento\GiftCardAccount\Api\Data\GiftCardAccountInterfaceFactory;
use Magento\GiftCardAccount\Api\Data\GiftCardAccountSearchResultInterface;
use Magento\GiftCardAccount\Api\Data\GiftCardAccountSearchResultInterfaceFactory;
use Overdose\GiftCardAccountApi\Api\Data\GiftCardAccountSearchResultInterface as OGCASRI;
use Overdose\GiftCardAccountApi\Api\Data\GiftCardAccountSearchResultInterfaceFactory as OGCASRIF;

class GiftCardAccountRepository implements \Overdose\GiftCardAccountApi\Api\GiftCardAccountRepositoryInterface
{
    /**
     * @var EntityManager
     */
    private $entityManager;

    private $giftcardaccountFactory;

    private $ogcaf;

    protected $_giftCardAccount;

    /**
     * @var \Magento\Framework\Stdlib\DateTime\Filter\Date
     */
    protected $_dateFilter;

    /**
     * @var \Magento\Store\Model\StoreManager
     */
    protected $_storeManager;

    protected $emailManagement;

    protected $resourceModel;

    /**
     * @var SearchCriteriaBuilder
     */
    private $searchCriteriaBuilder;

    /**
     * @var GiftCardAccountInterfaceFactory
     */
    private $giftCardAccountDataFactory;

    /**
     * @var GiftCardAccountSearchResultInterfaceFactory
     */
    private $searchResultsFactory;

    /**
     * @var OGCASRIF
     */
    private $ogcasrif;

    /**
     * @var OGCAI
     */
    private $ogcai;

    /**
     * @var OGCAIF
     */
    private $ogcaif;

    /**
     * @var DataObjectHelper
     */
    private $dataObjectHelper;

    /**
     * @var DataObjectProcessor
     */
    private $dataObjectProcessor;

    /**
     * @var JoinProcessorInterface
     */
    private $extensionAttributesJoinProcessor;
    /**
     * @var array
     */
    private $registry = [];

    /**
     * @var []
     */
    private $registryByCode = [];

    public function __construct(
        EntityManager $entityManager,
        GiftcardaccountFactory $giftcardaccountFactory,
        GiftCardAccountInterface $giftCardAccount,
        GiftCardAccountInterfaceFactory $giftCardAccountDataFactory,
        OGCAF $ogcaf,
        OGCAI $ogcai,
        OGCAIF $ogcaif,
        DataObjectHelper $dataObjectHelper,
        DataObjectProcessor $dataObjectProcessor,
        GiftCardAccountSearchResultInterfaceFactory $searchResultsFactory,
        OGCASRIF $ogcasrif,
        JoinProcessorInterface $extensionAttributesJoinProcessor,
        \Magento\GiftCardAccount\Model\ResourceModel\Giftcardaccount $resourceModel,
        \Magento\Framework\Stdlib\DateTime\Filter\Date $dateFilter,
        \Magento\Store\Model\StoreManager $storeManager,
        SearchCriteriaBuilder $searchCriteriaBuilder
    ) {
        $this->entityManager = $entityManager;
        $this->giftcardaccountFactory = $giftcardaccountFactory;
        $this->_giftCardAccount = $giftCardAccount;
        $this->giftCardAccountDataFactory = $giftCardAccountDataFactory;
        $this->ogcaf = $ogcaf;
        $this->ogcaif = $ogcaif;
        $this->dataObjectHelper = $dataObjectHelper;
        $this->dataObjectProcessor = $dataObjectProcessor;
        $this->searchResultsFactory = $searchResultsFactory;
        $this->ogcasrif = $ogcasrif;
        $this->extensionAttributesJoinProcessor = $extensionAttributesJoinProcessor;
        $this->resourceModel = $resourceModel;
        $this->_dateFilter = $dateFilter;
        $this->_storeManager = $storeManager;
        $this->searchCriteriaBuilder = $searchCriteriaBuilder;
    }

    /**
     * {@inheritdoc}
     */
    public function save($giftCard)
    {
        $new = false;
        if (!$giftCard->getId()){
            $new = true;
        }
        // check if data sent
        $data = $giftCard->getData();

        $model = $this->getByCode($giftCard->getCode() ? $giftCard->getCode() : '',true);

        $data = $this->_filterPostData($data);

        if (!array_key_exists('website_id', $data)/*$this->_storeManager->isSingleStoreMode()*/) {
            $data['website_id'] = $this->_storeManager
            ->getStore(
                true
            )->getWebsiteId();
        }

        if (!empty($data)) {
            $model->addData($data);
        }

        // try to save it
        try {
            $model->save();
            /*if ($model->getSendAction()) {
                if ($model->getStatus()) {
                    $this->sendEmail($model);
                } else {
                    $this->messageManager->addSuccess(__('You saved the gift card account.'));
                    $this->messageManager->addNotice(
                        __('An email was not sent because the gift card account is not active.')
                    );
                }
            } else {
                $this->messageManager->addSuccess(__('You saved the gift card account.'));
            }*/
        } catch (\Exception $e) {
            throw new CouldNotSaveException(__('Could not save the gift card account.'), $e);
        }

        $this->registry[$model->getId()] = $model;
        $this->registryByCode[$model->getCode()] = $model;

        if ($new) {
            echo json_encode($model->getData());
            return null;
        }

        return $model;
    }


    /**
     * {@inheritdoc}
     */
    public function getList(\Magento\Framework\Api\SearchCriteriaInterface $searchCriteria)
    {
        /** @var OGCASRIF $searchResults */
        $searchResults = $this->ogcasrif->create()
            ->setSearchCriteria($searchCriteria);

        $collection = $this->ogcaf->create()->getCollection();
        //$collection = $this->giftcardaccountFactory->create()->getCollection();
        $this->extensionAttributesJoinProcessor->process($collection, OGCAI::class);
        foreach ($searchCriteria->getFilterGroups() as $filterGroup) {
            $fields = [];
            $conditions = [];
            foreach ($filterGroup->getFilters() as $filter) {
                if ($filter->getField() == 'quote') {
                    $collection->addNotApplyInQuoteFilter($filter->getValue());
                } else {
                    $condition = $filter->getConditionType() ? $filter->getConditionType() : 'eq';
                    $fields[] = $filter->getField();
                    $conditions[] = [$condition => $filter->getValue()];
                }
            }
            if ($fields) {
                $collection->addFieldToFilter($fields, $conditions);
            }
        }
        $searchResults->setTotalCount($collection->getSize());
        if ($sortOrders = $searchCriteria->getSortOrders()) {
            /** @var \Magento\Framework\Api\SortOrder $sortOrder */
            foreach ($sortOrders as $sortOrder) {
                $collection->addOrder($sortOrder->getField(), $sortOrder->getDirection());
            }
        }

        $collection
            ->setCurPage($searchCriteria->getCurrentPage())
            ->setPageSize($searchCriteria->getPageSize());

        $giftcardaccounts = [];

        /** @var OGCA $giftcardaccountModel */
        foreach ($collection as $giftcardaccountModel) {
            //$giftcardaccounts[] = $giftcardaccountModel;
            $giftcardaccounts[] = $this->getGiftcardaccountDataObject($giftcardaccountModel);
        }
        $searchResults->setItems($giftcardaccounts);
        return $searchResults;
    }

    /**
     * Filtering posted data. Converting localized data if needed
     *
     * @param array $data
     * @return array
     */
    protected function _filterPostData($data)
    {
        if (!empty($data['date_expires'])) {
            $data['date_expires'] = $this->_dateFilter->filter($data['date_expires']);
        }
        unset($data['id']);
        //unset($data['code']);

        return $data;
    }

    /**
     * Load GCA from request
     *
     * @param string $idFieldName
     * @return \Magento\GiftCardAccount\Model\Giftcardaccount
     */
    protected function _initGca($idFieldName = 'id', $id = 0)
    {
        //$id = (int)$this->getRequest()->getParam($idFieldName);
        $model = $this->_giftCardAccount;
        if ((int)$id > 0) {
            $model->load($id);
        }
        //$this->_coreRegistry->register('current_giftcardaccount', $model);
        return $model;
    }

    /**
     * Send email to customer
     *
     * @param GiftCardAccountInterface $model
     * @return void
     */
    /*
    private function sendEmail(GiftCardAccountInterface $model)
    {
        if ($this->emailManagement->sendEmail($model)) {
            $this->messageManager->addSuccess(__('You saved the gift card account.'));
        } else {
            $this->messageManager->addError(
                __('You saved the gift card account, but an email was not sent.')
            );
        }
    }
*/

    /**
     * {@inheritdoc}
     */
    public function getById($id)
    {
        if (!isset($this->registry[$id])) {
            $giftCard = $this->giftCardAccountDataFactory->create();
            //echo get_class($giftCard); exit;
            //$this->entityManager->load($giftCard, $id);
            $giftCard->load($id);
            if (!$giftCard->getId()) {
                throw NoSuchEntityException::singleField('giftcardaccount_id', $id);
            }
            $this->registry[$id] = $giftCard;
            $this->registryByCode[$giftCard->getCode()] = $giftCard;
        }
        return $this->registry[$id];
    }

    /**
     * {@inheritdoc}
     */
    public function getByCode($code, $post = false)
    {
        $id = $this->resourceModel->getIdByCode($code);

        if (!$id) {
            if ($post) {
                return $this->giftCardAccountDataFactory->create();
            }
            else {
                throw new NoSuchEntityException(
                    __("The Gift Card Account that was requested doesn't exist. Verify the code and try again.")
                );
            }
        }

        return $this->getById($id);
    }

    /**
     * Retrieves giftcardaccount data object using Giftcard Model
     *
     * @param $giftcardaccount
     * @return GiftcardAccountInterface
     */
    private function getGiftcardaccountDataObject($giftcardaccount)
    {
        /** @var OGCAIF $giftcardDataObject */
        $giftcardaccountDataObject = $this->ogcaif->create();
        $this->dataObjectHelper->populateWithArray(
            $giftcardaccountDataObject,
            $giftcardaccount->getData(),
            OGCAI::class
        );

        return $giftcardaccountDataObject;
    }

    public function deleteByCode($code)
    {
        $id = $this->resourceModel->getIdByCode($code);

        if (!$id) {
            throw new NoSuchEntityException(
                __("The Gift Card Account that was requested doesn't exist. Verify the code and try again.")
            );
        }

        return $this->deleteById($id);
    }

    public function deleteById($id)
    {
        $giftCardAccount = $this->getById($id);
        return $this->delete($giftCardAccount);
    }

    public function delete(\Magento\GiftCardAccount\Api\Data\GiftCardAccountInterface $giftCardAccount)
    {
        $id = $giftCardAccount->getId();
        $code = $giftCardAccount->getCode();
        try {
            $this->resourceModel->delete($giftCardAccount);
        } catch (ValidatorException $e) {
            throw new CouldNotSaveException(__($e->getMessage()), $e);
        } catch (\Exception $e) {
            throw new \Magento\Framework\Exception\StateException(
                __('The "%1" gift card account couldn\'t be removed.', $code),
                $e
            );
        }
        if (isset($this->registry[$id])) {
            unset($this->registry[$id]);
        }

        return true;
    }
}
