<?php
namespace Overdose\GiftCardAccountApi\Api;

interface GiftCardAccountRepositoryInterface
{
    /**
     * Create/Update Gift Card Account
     *
     * @param \Overdose\GiftCardAccountApi\Api\Data\GiftCardAccountInterface $giftCard
     * @return \Overdose\GiftCardAccountApi\Api\Data\GiftCardAccountInterface|\Magento\GiftCardAccount\Api\Data\GiftCardAccountInterface|Magento\GiftCardAccount\Model\Giftcardaccount|string|null
     * @throws \Magento\Framework\Exception\CouldNotSaveException
     */
    public function save(\Overdose\GiftCardAccountApi\Api\Data\GiftCardAccountInterface $giftCard);

    /**
     * Get info about Gift Card Account by Gift Card Code
     *
     * @param string $code
     * @return \Overdose\GiftCardAccountApi\Api\Data\GiftCardAccountInterface
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getByCode($code);

    /**
     * Delete Gift Card Account by Gift Card Code
     * @param string $code
     * @return bool Will returned True if deleted
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     * @throws \Magento\Framework\Exception\StateException
     */
    public function deleteByCode($code);

    /**
     * Get Gift Card Account list
     *
     * @param \Magento\Framework\Api\SearchCriteriaInterface $searchCriteria
     * @return \Overdose\GiftCardAccountApi\Api\Data\GiftCardAccountSearchResultInterface
     */
    public function getList(\Magento\Framework\Api\SearchCriteriaInterface $searchCriteria);
}
