<?php
namespace Overdose\GiftCardAccountApi\Api\Data;

/**
 * Gift Card Account data
 */
interface GiftCardAccountInterface extends \Magento\GiftCardAccount\Api\Data\GiftCardAccountInterface
{
    /**
     * Gift cards id
     *
     * @return int|null
     */
    public function getId();

    /**
     * Set Gift cards id
     *
     * @param int $id
     * @return $this
     */
    public function setId($id);

    /**
     * Gift cards codes.
     *
     * Will return actual gift card accounts' codes if this object is a composite entity.
     *
     * @return string|null
     */
    public function getCode();

    /**
     * Gift set cards codes.
     *
     * Will return actual gift card accounts' codes if this object is a composite entity.
     *
     * @param string $code
     * @return $this
     */
    public function setCode($code);

    /**
     * Gift card get status.
     *
     * Get whether the gift card account and code is active
     *
     * @return int|null
     */
    public function getStatus();

    /**
     * Gift card set status.
     *
     * Set whether the gift card account and code is active
     *
     * @param int
     * @return $this
     */
    public function setStatus($status);

    /**
     * Gift cards Date Created.
     *
     * Will return actual gift card accounts' codes if this object is a composite entity.
     *
     * @return string|null
     */
    public function getDateCreated();

    /**
     * Gift cards set Date Created.
     *
     * Will return actual gift card accounts' codes if this object is a composite entity.
     *
     * @param string $date
     * @return $this
     */
    public function setDateCreated($dateCreated);

    /**
     * Gift cards get date expires.
     *
     * Will return actual gift card accounts' codes if this object is a composite entity.
     *
     * @return string|null
     */
    public function getDateExpires();

    /**
     * Gift cards set date expires.
     *
     * Will return actual gift card accounts' codes if this object is a composite entity.
     *
     * @param string $dateExpires
     * @return $this
     */
    public function setDateExpires($dateExpires);

    /**
     * Gift cards codes.
     *
     * Will return actual gift card accounts' codes if this object is a composite entity.
     *
     * @return int|null
     */
    public function getWebsiteId();

    /**
     * Gift cards codes.
     *
     * Will return actual gift card accounts' codes if this object is a composite entity.
     *
     * @param int $websiteId
     * @return $this
     */
    public function setWebsiteId($websiteId);

    /**
     * Gift cards get state.
     *
     * Will return actual gift card accounts' codes if this object is a composite entity.
     *
     * @return int|null
     */
    public function getState();

    /**
     * Gift cards set state.
     *
     * Only for composite entity.
     *
     * @param int $state
     * @return $this
     */
    public function setState($state);

    /**
     * Gift cards get balance.
     *
     * @return float|null
     */
    public function getBalance();

    /**
     * Gift cards set balance.
     *
     * Only for composite entity.
     *
     * @param float $balance
     * @return $this
     */
    public function setBalance($balance);

    /**
     * Gift cards get is Redeemable.
     *
     * Will return actual gift card accounts' codes if this object is a composite entity.
     *
     * @return int|null
     */
    public function getIsRedeemable();

    /**
     * Gift cards set is Redeemable.
     *
     * Will return actual gift card accounts' codes if this object is a composite entity.
     *
     * @param int $isRedeemable
     * @return $this
     */
    public function setIsRedeemable($isRedeemable);
}
