define([], function() {
        "use strict";
        return {
            getCookie : function(name){
                var cookie = " " + document.cookie,
                 search = " " + name + "=",
                 setStr = null,
                 offset = 0,
                  end = 0;
                if (cookie.length > 0) {
                    offset = cookie.indexOf(search);
                    if (offset !== -1) {
                        offset += search.length;
                        end = cookie.indexOf(";", offset);
                        if (end === -1) {
                            end = cookie.length;
                        }
                        setStr = decodeURI(cookie.substring(offset, end));
                    }
                }
                return(setStr);
            },

            setCookie : function (name, value, hours) {
                let expires = "";
                if (hours) {
                    let date = new Date();
                    date.setTime(date.getTime() + (hours * 60 * 60 * 1000));
                    expires = "; expires=" + date.toUTCString();
                }
                document.cookie = name + "=" + (value || "")  + expires + "; path=/";
            },

            delCookie : function(name) {
                var date = new Date(0);
                document.cookie = name + "=" + "; path=/; expires=" + date.toUTCString();
            },

            parseJson : function (json) {
                json = decodeURIComponent(json.replace(/\+/g, ' '));
                return JSON.parse(json);
            }
        };
    });
