<?php

namespace Overdose\DataLayer\Plugin;

use Magento\Checkout\Controller\Onepage\Success;
use Magento\Framework\Controller\ResultInterface;
use Magento\Framework\Exception\InputException;
use Magento\Framework\Stdlib\Cookie\CookieSizeLimitReachedException;
use Magento\Framework\Stdlib\Cookie\FailureToSendException;

/**
 * Class CheckoutSuccess
 * @package Overdose\DataLayer\Plugin
 */
class CheckoutSuccess extends GenericPlugin
{
    /**
     * @param Success $subject
     * @param ResultInterface $result
     * @return ResultInterface
     * @throws CookieSizeLimitReachedException
     * @throws FailureToSendException
     * @throws InputException
     */
    public function afterExecute(Success $subject, ResultInterface $result): ResultInterface
    {
        $orderInfo = $this->session->getLastRealOrder();
        $customerEmail = $orderInfo->getCustomerEmail();

        if ($customerEmail) {
            $customerEmail = strtolower($customerEmail);
        }

        $this->cookiesHelper->setDataLayerCookieUserIdentify($customerEmail, $orderInfo, true);

        return $result;
    }
}
