<?php

namespace Overdose\Customer\Observer\Customer\Address;

use Magento\Framework\App\RequestInterface;
use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\View\Layout;

class AddCustomHandle implements ObserverInterface
{
    /** @var RequestInterface */
    private $request;

    public function __construct(RequestInterface $request)
    {
        $this->request = $request;
    }

    public function execute(Observer $observer)
    {
        if ($observer->getData('full_action_name') === 'customer_address_form') {
            /** @var Layout $layout */
            $layout = $observer->getData('layout');

            $explodedPathInfo = explode('/', trim($this->request->getPathInfo(), '/'));
            $handleName = implode('_', array_slice($explodedPathInfo, 0, 3));
            $layout->getUpdate()->addHandle($handleName);
        }
    }
}
