<?php

namespace Overdose\Customer\Block;

use Magento\Customer\Block\Account\SortLinkInterface;

class SubMenuLink extends \Magento\Framework\View\Element\Html\Link\Current implements SortLinkInterface
{
    private const SUBPAGES = [
        'customer/address' => [
            'customer/address/new',
            'customer/address/edit'
        ]
    ];

    /**
     * {@inheritdoc}
     */
    public function getSortOrder()
    {
        return $this->getData(self::SORT_ORDER);
    }

    protected function _toHtml()
    {
        if (false != $this->getTemplate()) {
            return parent::_toHtml();
        }

        $highlight = '';

        if ($this->getIsHighlighted()) {
            $highlight = ' current';
        }

        if ('/' . $this->getPath() . '/' == $this->getRequest()->getPathInfo()) {
            $highlight = ' current';
        }

        $tlinks = $this->sortLinks($this->getLinks());
        $sublinkshtml = '';
        $isactive = '';
        if ($tlinks) {
            foreach ($tlinks as $link) {
                $current = ($this->isSubmenuCurrent($link['path'])) ? ' current' : '';
                if ($isactive == '') {
                    $isactive = ($this->isSubmenuCurrent($link['path'])) ? ' is-active' : '';
                }
                $sublinkshtml .= '<li class="' . $current . '"';
                $sublinkshtml .= '><a href="' . $this->escapeHtml($this->getUrl($link['path'])) . '"';
                $sublinkshtml .= '>';
                $sublinkshtml .= $link['label'];
                $sublinkshtml .= '</a>';
            }
        }

        if ($this->isCurrent()) {
            $html = '<li class="nav item current">';
            $html .= '<strong>'
                . __($this->getLabel())
                . '</strong>';
        } else {
            $html = '<li class="nav item account-sub-menu' . $highlight . '"';
            $html .= ' data-bind="scope: \'customer-component\'"';
            $html .= '><a href="javascript:void(0);"';
            $html .= 'data-bind="click: toggleAccountSubmenu" class="sidebar-mydetails-menu';
            if ($isactive!="") {
                $html .= ' is-active';
            }
            $html .= '"';
            $html .= $this->getTitle()
                ? ' title="' . $this->escapeHtml(__($this->getTitle())) . '"'
                : '';

            $html .= $this->getAttributesHtml() . '>';

            if ($this->getIsHighlighted()) {
                $html .= '<strong>';
            }

            $html .= __($this->getLabel());

            if ($this->getIsHighlighted()) {
                $html .= '</strong>';
            }

            $html .= '</a>';
        }

        if ($tlinks) {
            $html .= '<ul id="sidebar-mydetails-submenu" class="sidebar-mydetails-submenu ' . $isactive . '">';
            $html .= $sublinkshtml;
            $html .= '</ul>';
        }

        $html .= '</li>';

        return $html;
    }

    public function sortLinks($sort)
    {
        $newarray = [];
        foreach ($sort as $key => $link) {
            if ($key==0) {
                array_push($newarray, $link);
            } else {
                if ($newarray[$key-1]['sort']<$link['sort']) {
                    $tmp = $newarray[$key-1];
                    $newarray[$key-1]=$link;
                    array_push($newarray, $tmp);
                } else {
                    array_push($newarray, $link);
                }
            }
        }

        return $newarray;
    }

    public function isSubmenuCurrent($path)
    {
        $currentPagePath = trim($this->getRequest()->getPathInfo(), '/');
        $pagePathExploded = explode('/', $currentPagePath);
        $pagePath = implode('/', array_slice($pagePathExploded, 0, 3));

        $isSubpageCurrent = in_array($pagePath, self::SUBPAGES[$path] ?? []);

        if ($path == $currentPagePath || $isSubpageCurrent) {
            return true;
        } else {
            return parent::isCurrent();
        }
    }

    /**
     * @return bool
     */
    public function isCurrent()
    {
        if ('/' . $this->getPath() . '/' == $this->getRequest()->getPathInfo()) {
            return true;
        } else {
            return parent::isCurrent();
        }
    }
}
