<?php

namespace Overdose\CatalogSortToolbar\Plugin\Product\ProductList;

use Magento\Catalog\Model\CategoryRepository;

class Toolbar
{
    /**
    * Plugin
    *
    * @param \Magento\Catalog\Block\Product\ProductList\Toolbar $subject
    * @param \Closure $proceed
    * @param \Magento\Framework\Data\Collection $collection
    * @return \Magento\Catalog\Block\Product\ProductList\Toolbar
    */
    public function aroundSetCollection(
        \Magento\Catalog\Block\Product\ProductList\Toolbar $subject,
        \Closure $proceed,
        $collection
    ) {
        $currentOrder = $subject->getCurrentOrder();

        switch ($currentOrder) {
            case 'name_a_z':
                $subject->setData('_current_grid_order', 'name');
                $subject->setData('_current_grid_direction', 'asc');
                break;
            case 'name_z_a':
                $subject->setData('_current_grid_order', 'name');
                $subject->setData('_current_grid_direction', 'desc');
                break;
            case 'price_low_to_high':
                $subject->setData('_current_grid_order', 'price');
                $subject->setData('_current_grid_direction', 'asc');
                break;
            case 'price_high_to_low':
                $subject->setData('_current_grid_order', 'price');
                $subject->setData('_current_grid_direction', 'desc');
                break;
            case 'newest':
                $subject->setData('_current_grid_order', 'sort_order_new');
                $subject->setData('_current_grid_direction', 'asc');
                break;
        }

        $result = $proceed($collection);
        $subject->setData('_current_grid_order', $currentOrder);

        return $result;
    }
}
