<?php
namespace Overdose\Catalog\Plugin\Product\ProductList;

/**
 * Class Toolbar
 * @package Overdose\Catalog\Plugin\Product\ProductList
 */
class Toolbar
{
    /**
     * @param \Magento\Catalog\Block\Product\ProductList\Toolbar $subject
     * @param \Closure $proceed
     * @param $collection
     * @return mixed
     */
    public function aroundSetCollection(
        \Magento\Catalog\Block\Product\ProductList\Toolbar $subject,
        \Closure $proceed,
        $collection
    ) {
        $currentOrder = $subject->getCurrentOrder();
        switch ($currentOrder) {
            case 'name_a_z':
                $collection->setOrder('name', 'asc');
                break;
            case 'name_z_a':
                $collection->setOrder('name', 'desc');
                break;
            case 'price_low_to_high':
                $collection->setOrder('price', 'asc');
                break;
            case 'price_high_to_low':
                $collection->setOrder('price', 'desc');
                break;
        }
        return $proceed($collection);
    }
}
