<?php

namespace Overdose\Catalog\Model;

use Magento\VisualMerchandiser\Model\Category\Builder;
use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use Magento\VisualMerchandiser\Model\RulesFactory;
use Magento\Catalog\Model\CategoryFactory;

class RebuildPositionCategory
{
    /**
     * @var Builder
     */
    protected $categoryBuilder;

    /**
     * @var RulesFactory
     */
    protected $rulesFactory;

    /**
     * @var CategoryFactory
     */
    protected $categoryFactory;

    protected $categories = [];

    /**
     * Constructor
     *
     * @param Builder $categoryBuilder
     * @param RulesFactory $rulesFactory
     * @param CategoryFactory $categoryFactory
     */
    public function __construct(
        Builder         $categoryBuilder,
        RulesFactory    $rulesFactory,
        CategoryFactory $categoryFactory
    ) {
        $this->categoryFactory = $categoryFactory;
        $this->categoryBuilder = $categoryBuilder;
        $this->rulesFactory = $rulesFactory;
    }

    public function rebuildPositionByCategoryId($id)
    {
        if (!isset($this->categories[$id])) {
            $this->categories[$id] = $this->categoryFactory->create()->load($id);
        }

        if (!$this->categories[$id] || !$this->categories[$id]->getId()) {
            return;
        }

        /* @var \Magento\Catalog\Model\Category $category */
        $category = $this->categories[$id];

        // Disable smart category rule after application
        /** @var \Magento\VisualMerchandiser\Model\Rules $rules */
        $rules = $this->rulesFactory->create();
        $rule = $rules->loadByCategory($category);
        if ($rule->getId() && $rule->getIsActive()) {
            $this->categoryBuilder->rebuildCategory($category);
            $rule->setData([
                'rule_id'     => $rule->getId(),
                'category_id' => $category->getId(),
                'is_active'   => $rule->getIsActive()
            ]);
            try {
                $rule->save();
            }catch (\Exception $e) {

            }
        }
    }
}
