<?php
namespace Overdose\Catalog\Model;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Store\Model\ScopeInterface;
use Magento\Store\Model\StoreManagerInterface;

/**
 * Class ConfigProvider
 * @package Overdose\InviteFriend\Model
 */
class ConfigProvider
{
    /**
     * @var StoreManagerInterface
     */
    protected $storeManager;

    /**
     * @var
     */
    protected $currentStore;

    /**
     * @var ScopeConfigInterface
     */
    protected $scopeConfig;

    /**
     * Config value.
     */
    const XML_PATH_IN_STOCK_TEXT = 'catalogstock/configuration/in_stock_text';

    /**
     * Config value.
     */
    const XML_PATH_LOW_STOCK_THRESHOLD = 'catalogstock/configuration/low_stock_threshold';

    /**
     * Config value.
     */
    const XML_PATH_LOW_STOCK_TEXT = 'catalogstock/configuration/low_stock_text';

    /**
     * Config value.
     */
    const XML_PATH_OUT_OF_STOCK_THRESHOLD = 'catalogstock/configuration/out_of_stock_threshold';

    /**
     * Config value.
     */
    const XML_PATH_OUT_OF_STOCK_TEXT = 'catalogstock/configuration/out_of_stock_text';

    /**
     * Config value.
     */
    const XML_PATH_MAX_QTY_DROPDOWN = 'categorylisting/configuration/max_qty';

    /**
     * ConfigProvider constructor.
     * @param ScopeConfigInterface $scopeConfig
     * @param StoreManagerInterface $storeManager
     */
    public function __construct(
        ScopeConfigInterface $scopeConfig,
        StoreManagerInterface $storeManager
    ) {
        $this->storeManager = $storeManager;
        $this->scopeConfig = $scopeConfig;
    }

    /**
     * @return bool
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function inStockText()
    {
        return (string) $this->getValue(self::XML_PATH_IN_STOCK_TEXT);
    }

    /**
     * @return bool
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function lowStockThreshold()
    {
        return (string) $this->getValue(self::XML_PATH_LOW_STOCK_THRESHOLD);
    }

    /**
     * @return bool
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function lowStockText()
    {
        return (string) $this->getValue(self::XML_PATH_LOW_STOCK_TEXT);
    }

    /**
     * @return bool
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function outOfStockThreshold()
    {
        return (string) $this->getValue(self::XML_PATH_OUT_OF_STOCK_THRESHOLD);
    }

    /**
     * @return bool
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function outOfStockStockText()
    {
        return (string) $this->getValue(self::XML_PATH_OUT_OF_STOCK_TEXT);
    }

    /**
     * @return int
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getMaxAllowedQty()
    {
        return (int) $this->getValue(self::XML_PATH_MAX_QTY_DROPDOWN);
    }

    /**
     * @param $path
     * @return mixed
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getValue($path)
    {
        $value = $this->scopeConfig->getValue(
            $path,
            ScopeInterface::SCOPE_STORE,
            $this->storeManager->getStore()->getId()
        );

        return $value;
    }
}
