<?php
namespace Overdose\Catalog\Controller\Index;

use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\Controller\Result\Json;
use Magento\Framework\Controller\Result\JsonFactory;

use Magento\InventorySalesApi\Api\Data\SalesChannelInterface;

class Index extends Action
{
    /**
     * @var JsonFactory
     */
    private $jsonFactory;


    private $stockRegistry;

    public $productRepository;

    public $productSalable;

    public $stockResolver;

    public $storeManager;



    /**
     * @param Context $context
     * @param JsonFactory $jsonFactory
     */
    public function __construct(
        Context $context,
        JsonFactory $jsonFactory,
        \Magento\CatalogInventory\Api\StockRegistryInterface $stockRegistry,
        \Magento\Catalog\Api\ProductRepositoryInterface $productRepository,
        \Magento\InventorySalesApi\Api\GetProductSalableQtyInterface $productSalable,
        \Magento\InventorySalesApi\Api\StockResolverInterface $stockResolver,
        \Magento\Store\Model\StoreManagerInterface $storeManager
    )
    {
        parent::__construct($context);
        $this->jsonFactory = $jsonFactory;
        $this->stockRegistry = $stockRegistry;
        $this->productRepository = $productRepository;
        $this->productSalable = $productSalable;
        $this->stockResolver = $stockResolver;
        $this->storeManager  = $storeManager;
    }

        /**
     * Get website code
     *
     * @return string|null
     */
    public function getWebsiteCode(): ?string
    {
        try {
            $websiteCode = $this->storeManager->getWebsite()->getCode();
        } catch (LocalizedException $localizedException) {
            $websiteCode = null;
            $this->logger->error($localizedException->getMessage());
        }
        return $websiteCode;
    }

    // public function getSaleableStock($product_sku)
    // {
    //     // $productSalable = $objectManager->get('\Magento\InventorySalesApi\Api\GetProductSalableQtyInterface');
    //     // $stockResolver = $objectManager->get('\Magento\InventorySalesApi\Api\StockResolverInterface');

    //     $stockId    = $this->stockResolver->execute(SalesChannelInterface::TYPE_WEBSITE, $this->getWebsiteCode())->getStockId();
    //     $stockQty   = $this->productSalable->execute($product_sku, $stockId);

    //     return $stockQty;
    // }

    /**
     * @return Json
     */
    public function execute()
    {
        $result = $this->jsonFactory->create();
        $productId = $this->getRequest()->getParam('productId');
        // if (empty($email)) {
        //     $result->setData(['success' => false, 'error' => __('E-mail cannot be empty.')]);
        //     return $result;
        // }

        try {
            /** @var Subscriber $subscriber */
            // $subscriber = $this->subscriberFactory->create();
            // $subscriber->subscribe($email);

            $product = $this->productRepository->getById($productId);
            $product_sku = $product->getSku();
            $stockId    = $this->stockResolver->execute(SalesChannelInterface::TYPE_WEBSITE, $this->getWebsiteCode())->getStockId();
            $stockQty   = $this->productSalable->execute($product_sku, $stockId);





            $result->setData(['success' => true, 'stockQty' => $stockQty]);
        } catch (\Exception $e) {
            $result->setData(['success' => false, 'error' => __('Error.')]);
            // $result->setData(['success' => false, 'error' => $e->getMessage()]);
        }
        return $result;
    }
}
