<?php
namespace Overdose\Cart\Setup\Patch\Data;

use Magento\Cms\Model\BlockFactory;
use Magento\Cms\Model\ResourceModel\Block as BlockResource;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;
use Magento\Store\Model\Store;

class AddMiniCartShippingCalloutBlock implements DataPatchInterface
{
    /**
     * @param ModuleDataSetupInterface $moduleDataSetup
     * @param BlockFactory $blockFactory
     * @param BlockResource $blockResource
     */
    public function __construct(
        private ModuleDataSetupInterface $moduleDataSetup,
        private BlockFactory $blockFactory,
        private BlockResource $blockResource
    ) {
    }

    /**
     * @inheritdoc
     */
    public function apply()
    {
        $this->moduleDataSetup->startSetup();

        $asicsBlockData = [
            'title' => 'Mini Cart Shipping Callout',
            'identifier' => 'mini_cart_shipping_callout',
            'content' => '<div class="mini-cart-shipping-callout">
                            <strong>Free Shipping for all orders</strong>
                         </div>',
            'is_active' => 1,
            'stores' => [Store::DEFAULT_STORE_ID],
        ];

        try {
            $block = $this->blockFactory->create();
            $createdBlock = $block->load(
                'mini_cart_shipping_callout',
                'identifier'
            );

            if ($createdBlock->getId()) {
                $createdBlock->setContent($asicsBlockData['content'])->save();
            } else {
                $block->setData($asicsBlockData);
                $this->blockResource->save($block);
            }
        } catch (\Exception $e) {
            throw new \Magento\Framework\Setup\Exception(
                __("Could not create CMS block: %1", $e->getMessage())
            );
        }

        $this->moduleDataSetup->endSetup();
    }

    /**
     * @inheritdoc
     */
    public static function getDependencies(): array
    {
        return [];
    }

    /**
     * @inheritdoc
     */
    public function getAliases(): array
    {
        return [];
    }
}