<?php
declare(strict_types=1);

namespace Overdose\Cart\Plugin\Checkout\CustomerData;

use Magento\Checkout\Model\Session as CheckoutSession;
use Magento\Checkout\CustomerData\Cart as SubjectCart;
use Overdose\Catalog\Helper\Stock as StockHelper;

class Cart
{
    public function __construct(
        private readonly CheckoutSession $checkoutSession,
        private readonly StockHelper $stockHelper
    ) {
    }

    /**
     * Plugin after method to add qty_available if item to the 'cart' customer data section.
     *
     * @param SubjectCart $subject
     * @param array $result
     * @return array
     */
    public function afterGetSectionData(SubjectCart $subject, array $result): array
    {
        $quote = $this->checkoutSession->getQuote();
        $totals = $quote->getTotals();
        $grandTotalAmount = $totals['grand_total']->getValue();

        $result['grandTotalAmount'] = $grandTotalAmount;
        $result['grand_total'] = isset($totals['grand_total'])
                ? $this->checkoutHelper->formatPrice($grandTotalAmount)
                : 0,

        foreach ($result["items"] as $key => $item) {
            $result["items"][$key]['qty_available'] = max(1, min((int)$this->stockHelper->getSaleableStock($item["product_sku"]), 10));
        }

        return $result;
    }
}