<?php

declare(strict_types=1);

namespace Overdose\AmStoreLocatorExport\Controller\Adminhtml\Index;

use Magento\Backend\App\Action\Context;
use Overdose\AmStoreLocatorExport\Api\Data\GenerateAmastyLocationsExport;

/**
 * Create amasty locations file locations_export.csv file and download.
 */
class ExportLocations extends \Magento\Backend\App\Action
{
    /** @var GenerateAmastyLocationsExport */
    private $generateLocationsFile;

    /**
     * @param Context $context
     * @param GenerateAmastyLocationsExport $generateLocationsFile
     */
    public function __construct(
        Context $context,
        GenerateAmastyLocationsExport $generateLocationsFile
    ) {
        parent::__construct($context);
        $this->generateLocationsFile = $generateLocationsFile;
    }

    /**
     * @return \Magento\Framework\App\ResponseInterface|\Magento\Framework\Controller\ResultInterface|void
     * @throws \Magento\Framework\Exception\FileSystemException
     */
    public function execute()
    {
        $csvFile = $this->generateLocationsFile->generateAmastyLocationsExportFile();

        $this->_response->setHttpResponseCode(200)
            ->setHeader('Pragma', 'public', true)
            ->setHeader('Cache-Control', 'must-revalidate, post-check=0, pre-check=0', true)
            ->setHeader('Content-type', 'application/octet-stream', true)
            ->setHeader('Content-Length', strlen($csvFile), true)
            ->setHeader('Content-Disposition', 'attachment; filename="locations_export.csv"', true)
            ->setHeader('Last-Modified', date('r'), true)
            ->setBody($csvFile)
            ->sendResponse();
    }
}
