<?php

namespace Overdose\AddressValidation\Helper;
use Magento\Framework\App\Request\Http;

/**
 * Property of NZMUSCLE Ltd.
 *
 * @author      Tom Lin <tom@overdose.digital>
 * @package     Overdose_AddressValidation
 * @copyright   Copyright (c) 2018 NZMUSCLE Ltd.
 */
class Data extends \Magento\Framework\App\Helper\AbstractHelper
{
  protected $_storeManager;
  protected $_request;

  //Admin setting default path
  const OD_ADDRESS_SETTING = "overdose_addressvalidation/api/";
//  const API_LOG_FILENAME = '/var/log/od_address_validation_api.log';

  public function __construct(\Magento\Framework\App\Helper\Context $context,
      \Magento\Store\Model\StoreManagerInterface $storeManager,
      Http $request
  ) {
      $this->_storeManager  = $storeManager;
      $this->_request = $request;
      parent::__construct($context);
  }

  /**
   * Check if current requested URL is secure
   *
   * @return boolean
   */    
  public function isCurrentlySecure()
  {
      return $this->_storeManager->getStore()->isCurrentlySecure();
  } 


    /**
     * Retrieve enable/disable module
     *
     * @return boolean
     */
    public function getIsEnabled()
    {
        return $this->getConfig('is_enabled');
    }

    

    /**
     * Retrieve Token Url
     *
     * @return boolean
     */
    public function getTokenUrl()
    {
        return $this->getConfig('token_url');
    }

    /**
     * Retrieve Grant Type
     *
     * @return boolean
     */
    public function getGrantType()
    {
        return $this->getConfig('grant_type');
    }

    /**
     * Retrieve street lookup endpoint
     *
     * @return string
     */
    public function getStreetLookupEndpoint()
    {
        return $this->getConfig('streetlookup_endpoint');
    }

    /**
     * Retrieve addressId lookup endpoint
     *
     * @return string
     */
    public function getFullAddressEndpoint()
    {
        return $this->getConfig('fulladdress_endpoint');
    }

    /**
     * Retrieve API username
     *
     * @return string
     */
    public function getClientId()
    {
        return $this->getConfig('client_id');
    }
    /**
     * Retrieve API password
     *
     * @return string
     */
    public function getClientSecret()
    {
        return $this->getConfig('client_secret');
    }

    /**
     * Retrieve address lookup count
     *
     * @return int
     */
    public function getLookupCount()
    {
        return $this->getConfig('lookup_count');
    }


    /**
     * Retrieve enable/disable logging
     *
     * @return boolean
     */
    public function getLogEnabled()
    {
        return $this->getConfig('log_enabled');
    }

   /**
   * Return Admin Setting by passing the admin field name
   * @return string
   */
  public function getConfig($field)
  {
    $value = $this->scopeConfig->getValue(self::OD_ADDRESS_SETTING . $field, \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
    return $value;
  }


   /**
   * Return lookup URL, check if https should be used
   * @return string
   */
  public function getLookupUrl()
  {
    $lookupUrl = $this->_urlBuilder->getUrl('odaddress/ajax/lookup');
    return $lookupUrl;
  }

   /**
   * Return address URL, check if https should be used
   * @return string
   */
    public function getAddressUrl()
    {
      $addressurl = $this->_urlBuilder->getUrl('odaddress/ajax/address');
      return $addressurl;
    }

    /**
    * Log variable to API specific log file
    * @param $variable
    */
    public function log($variable, $prefix = null)
    {
        $logStatus = $this->getLogEnabled();
        if($logStatus){
            if(is_object($variable) || is_array($variable)) {
               $this->_logger->info(var_export($variable, true));
            } else {
                $this->_logger->info(($prefix) ? $prefix.': '.$variable : $variable);
            }
        }
    }

    public function getWebsiteBaseUrl()
    {
       //return $this->_storeManager->getStore()->getBaseUrl(\Magento\Framework\UrlInterface::URL_TYPE_WEB);
      return $this->_storeManager->getStore()->getBaseUrl();
    }

}