define([
    'jquery',
    'mage/url',
    'slick'
], function (
    $,
    url
) {
    if (window.searchspringProductsLoaded) {
        loadSwatches();
    }
    $(window).on('product-cards:init', function () {
        loadSwatches();
    });

    function initSlick($element) {
        $element.find('.show-more-btn').remove()
        $element.not('.slick-initialized').slick({
            dots: false,
            arrows: true,
            infinite: false,
            variableWidth: true,
            slidesToShow: 5
        });
    }

    function destroySlick($element, productsLength, productHref) {
        $element.find('.show-more-btn').remove()
        const MAX_SWATCHES = 2;

        const hiddenSwatchesCount = productsLength - MAX_SWATCHES;
        if (hiddenSwatchesCount > 0) {
            const moreSwatchesLink = $('<a></a>')
                .addClass('show-more-btn')
                .attr('href', productHref)
                .text(`+${hiddenSwatchesCount}`);
            $element.append(moreSwatchesLink);
        }

        if ($element.hasClass('slick-initialized')) {
            $element.slick('unslick');
        }
    }

    function handleSlick($element, productsLength, productHref) {
        const isMobile = window.innerWidth <= 1024;
        if (isMobile) {
            destroySlick($element, productsLength, productHref);
        } else {
            initSlick($element);
        }
    }

    function loadSwatches() {
        let styles = [];
        $('[data-style-id]').each(function () {
            styles.push($(this).attr('data-style-id'));
        });

        $.ajax({
            url: url.build('searchspring/superstyle/fetch'),
            type: 'GET',
            showLoader: true,
            dataType: 'json',
            data: {
                style_id: styles.join(','),
            },
            success: function (response) {
                try {
                    if (response) {
                        
                        /**
                         * 1. On frontend, loop through all product grid elements.
                         * 2. For each, use the style ID to grab the related products from the API data
                         * 3. Create DOM elements for the swatches (should match the current production swatches DOM elements)
                         * 4. Ensure swatch behaviour matches current production (hover changes image, link to product etc.)
                         */
                        $('li[data-style-id]').each(function () {
                            /**
                             *  1. Get information from response object
                             *  2. Create new element for the swatch and append it to product card
                             */
                            const listElement = $(this);
                            const styleID = listElement.attr('data-style-id');
                            const products = response[styleID];
                            const $hoverImageSrc = listElement.find('.product-item__hover-container').find('.product-image-photo').attr('src')
                            const $imageLink = listElement.find(".ss__image__link").eq(0);
                            const $imageContainer = listElement.find(".product-image-container").eq(0);
    
                            if ($hoverImageSrc.length) {
                                const $hoverImageElement = $('<img>').attr({
                                    'src': $hoverImageSrc.toString(),
                                    'loading': 'lazy'
                                }).addClass('product-image-photo');
    
                                const $wrapper = $('<span>').addClass('ss__image product-image-wrapper');
                                $wrapper.append($hoverImageElement);
    
                                $imageContainer.append($wrapper);
                            }
    
                            if ($imageContainer.hasClass('slick-initialized')) {
                                $imageContainer.slick('refresh');
                            } else {
                                $imageContainer.slick({
                                    arrows: true,
                                    dots: false,
                                    responsive: [
                                        {
                                            breakpoint: 768,
                                            settings: {
                                                dots: true
                                            }
                                        }
                                    ]
                                });
                            }                        
    
                            $imageContainer.on('click', '.slick-arrow', function(e) {
                                e.preventDefault();
                                e.stopPropagation();
                            });
    
                            const swatchInit = $('<div></div>').addClass('product-item__super-style-list');
                            const parentProduct = listElement.find("[id*='product-item-info_']").eq(0);
                            const entityId = parentProduct.attr('id').split('_')[1];
                            const swatchCheck = $(listElement[0]).find('.product-item__super-style-list').length;
    
                            if (swatchCheck === 0 && products) {
                                products.forEach((product) => {
                                    const isParent = entityId === product['entity_id'];
                                    const swatchProduct = buildSwatch(product, isParent);
                                    swatchInit.append(swatchProduct);
    
                                    if (!isParent) {
                                        // Image to display on card
                                        const url = new URL(product['image']);
                                        const cardParams = new URLSearchParams({
                                            width: '250',
                                            height: '250',
                                            canvas: '250,250',
                                            quality: '80',
                                            'bg-color': '255,255,255',
                                            fit: 'bounds'
                                        });
    
                                        url.search = cardParams.toString();
                                        const productCardImage = $('<img>')
                                            .attr({
                                                'src': url.toString(),
                                                'loading': 'lazy'
                                            })
                                            .addClass('superstyle-img-' + product['entity_id']);
                                        $(`#${parentProduct.attr('id')} > a > div`).eq(0).append(productCardImage);
                                    }
                                });
    
                                $imageLink.after(swatchInit);
                                handleSlick(swatchInit, products.length, parentProduct.find('a.product-item-link').attr('href'));
                                $(window).on('resize', function () {
                                    handleSlick(swatchInit, products.length, parentProduct.find('a.product-item-link').attr('href'));
                                });
                            }
                        });
                    }
                } catch (e) {
                    console.log(e);
                }                
            },

            error: function (xhr, status, error) {
                console.log('Error:', error);
            }
        });
    }

    function buildSwatch(swatchInfo, isCurrent) {
        // Create productAnchor with jQuery and set its href
        const productAnchor = $('<a></a>')
            .addClass('product-item__super-style-list__item' + (isCurrent ? ' product-item__super-style-list__item--current' : ' product-item__super-style-list__item'))
            .attr({
                'href': swatchInfo['url_key'],
                'id': swatchInfo['entity_id'],
            });

        const url = new URL(swatchInfo['image']);
        const params = new URLSearchParams({
            width: '40',
            height: '30',
            canvas: '40,60',
            quality: '80',
            'bg-color': '255,255,255',
            fit: 'bounds'
        });
        url.search = params.toString();

        const productImage = $('<img>')
            .attr({
                'src': url.toString(),
                'width': 42,
                'height': 42,
                'loading': 'lazy'
            });

        productAnchor.append(productImage);

        return productAnchor;
    }
});
