<?php

namespace BrittainWynyard\Searchspring\ViewModel\Source\Catalog;

use BrittainWynyard\Searchspring\ViewModel\ConfigProvider;
use Magento\Customer\Model\Session;
use Magento\Framework\Registry;
use Magento\Framework\View\Element\Template;
use Magento\Framework\View\Element\Template\Context;

class Category extends Template
{

    const EXCLUDED_CATEGORIES = ['Default Category', 'Root Catalog'];
    const SCRIPT_URL_TEMPLATE = 'https://snapui.searchspring.io/%s/bundle.js';

    public function __construct(
        private readonly Registry $registry,
        private readonly ConfigProvider $configProvider,
        private readonly Session $customerSession,
        Context $context,
        $data = [],
    )
    {
        parent::__construct($context, $data);
    }

    /**
     * @return string
     */
    public function getCategoryConfig(): string
    {
        if (!$this->configProvider->isEnabled()) {
            return '';
        }

        // Get data from objectManager
        $category = $this->registry->registry('current_category');
        // Update details if on category
        if (isset($category)) {
            $category_id = $category->getId();
            $category_name = str_replace('"', '&qout;', $category->getName());
            $category_copy = $category;

            // Build category path and trim characters
            $category_array = [];
            while (!in_array($category_copy->getName(), self::EXCLUDED_CATEGORIES)) {
                $category_array[] = trim(htmlspecialchars($category_copy->getName()));
                $category_copy = $category_copy->getParentCategory();
            }
            $ss_category_path = implode('>', array_reverse($category_array));

            // Add category filter (but not on search category)
            if ($category_id != $this->configProvider->getCatalogID()) {
                return "category = { id : \"$category_id\", name : \"$category_name\", path : \"$ss_category_path\" };";
            }
        }
        return '';
    }

    /**
     * @return string
     */
    public function getDeferConfig(): string {
        if (!$this->configProvider->isEnabled()) {
            return '';
        }

        $ss_category = $this->registry->registry('current_category');
        if (!isset($ss_category)) {
            return 'defer';
        }
        return '';
    }

    /**
     * @return string
     */
    public function getScriptUrl(): string {
        return sprintf(self::SCRIPT_URL_TEMPLATE, $this->configProvider->getSiteID());
    }
}
