<?php

declare(strict_types=1);

namespace BrittainWynyard\Searchspring\Plugin;

use BrittainWynyard\Searchspring\Model\Feed\DataProvider\ChildStockProvider;
use SearchSpring\Feed\Model\Feed\DataProviderInterface;
use SearchSpring\Feed\Model\Feed\DataProviderPool;

/**
 * Adds child stock provider to the data provider pool
 */
class AddChildStockProvider
{
    public function __construct(
        private readonly ChildStockProvider $childStockProvider
    ) {
    }

    /**
     * Add child stock provider
     *
     * @param DataProviderPool $subject
     * @param DataProviderInterface[] $result
     * @param array $ignoredFields
     * @return DataProviderInterface[]
     */
    public function afterGet(DataProviderPool $subject, array $result, array $ignoredFields = []): array
    {
        $result['bw_child_stock'] = $this->childStockProvider;

        return $result;
    }
}
