<?php
namespace BrittainWynyard\Sales\Model\Order;

class ShippingAssignmentBuilder extends \Magento\Sales\Model\Order\ShippingAssignmentBuilder
{
    /**
     * Set suburb as an extension attribute on shipping address so that it can be read through API
     * @return \Magento\Sales\Api\Data\ShippingAssignmentInterface[]|null
     */
    public function create()
    {
        $shippingAssignments = parent::create();

        foreach ($shippingAssignments as $shippingAssignment) {
            $address = $shippingAssignment->getShipping()->getAddress();

            if (!is_null($address)) {
                $addressExtensionAttributes = $address->getExtensionAttributes();

                if (!is_null($addressExtensionAttributes)) {
                    $addressExtensionAttributes->setSuburb($address->getSuburb());
                    $addressExtensionAttributes->setBuilding($address->getBuilding());
                }
            }
        }

        return $shippingAssignments;
    }
}
