<?php

namespace BrittainWynyard\OneAsics\Controller\Change;

use Magento\Customer\Model\Session as CustomerSession;
use Magento\Framework\App\Action\Context;
use Magento\Framework\Controller\ResultFactory;

/**
 * Class Password
 */
class Password extends \Magento\Framework\App\Action\Action
{
    /**
     * @var \BrittainWynyard\OneAsics\OAuth2\Client\Provider\OneAsicsPassword
     */
    protected $oneAsicsProviderPassword;

    /**
     * @var \BrittainWynyard\OneAsics\Helper\Config
     */
    protected $configHelper;

    /**
     * @var \Psr\Log\LoggerInterface
     */
    protected $logger;

    /**
     * @var CustomerSession
     */
    protected  $customerSession;

    /**
     * @var \Magento\Store\Model\StoreManagerInterface $storeManager,
     */
    protected $storeManager;

    /**
     * @param Context $context
     * @param \BrittainWynyard\OneAsics\OAuth2\Client\Provider\OneAsicsPassword $oneAsicsProviderPassword
     * @param \BrittainWynyard\OneAsics\Helper\Config $configHelper
     * @param \Psr\Log\LoggerInterface $logger
     * @param \Magento\Customer\Model\Session $customerSession
     * @param \Magento\Store\Model\StoreManagerInterface $storeManager
     */
    public function __construct(
        Context $context,
        \BrittainWynyard\OneAsics\OAuth2\Client\Provider\OneAsicsPassword $oneAsicsProviderPassword,
        \BrittainWynyard\OneAsics\Helper\Config $configHelper,
        \Psr\Log\LoggerInterface $logger,
        CustomerSession $customerSession,
        \Magento\Store\Model\StoreManagerInterface $storeManager
    ) {
        parent::__construct($context);
        $this->oneAsicsProviderPassword = $oneAsicsProviderPassword;
        $this->configHelper = $configHelper;
        $this->logger = $logger;
        $this->customerSession = $customerSession;
        $this->storeManager = $storeManager;
    }

    /**
     * @return \Magento\Framework\App\ResponseInterface|\Magento\Framework\Controller\ResultInterface
     */
    public function execute()
    {
        $resultRedirect = $this->resultFactory->create(ResultFactory::TYPE_REDIRECT);
        if (!$this->_request->getParam('state')) {
            $changePassUrl = $this->oneAsicsProviderPassword->getAuthorizationUrl();

            if ($this->configHelper->isDebugMode()) {
                $this->logger->info($changePassUrl);
            }

            return $this->getResponse()->setRedirect(
                $changePassUrl,
                302
            );
        } else{
            $customerId = $this->customerSession->getId();
            if($customerId) {
                $this->customerSession->logout()->setLastCustomerId($customerId);
                $this->messageManager->addSuccessMessage("Password has been updated. Please login again using new password ");
                $resultRedirect->setPath('customer/account/login');
            }else{
                $resultRedirect->setPath('oneasics/login');
            }
            return $resultRedirect;
        }
    }
}
