<?php
namespace BrittainWynyard\GoogleTagManager\Model\Plugin\Quote;

class SetGoogleAnalyticsOnCartRemove extends \Magento\GoogleTagManager\Model\Plugin\Quote\SetGoogleAnalyticsOnCartRemove
{
    /**
     * @var \BrittainWynyard\GoogleTagManager\Helper\Data
     */
    protected $bwHelper;

    /**
     * @param \Magento\GoogleTagManager\Helper\Data $helper
     * @param \Magento\Framework\Registry $registry
     * @param \BrittainWynyard\GoogleTagManager\Helper\Data $bwHelper
     */
    public function __construct(
        \Magento\GoogleTagManager\Helper\Data $helper,
        \Magento\Framework\Registry $registry,
        \BrittainWynyard\GoogleTagManager\Helper\Data $bwHelper
    )
    {
        $this->bwHelper = $bwHelper;
        parent::__construct($helper, $registry);
    }

    /**
     * Sets item data to registry for triggering remove event.
     *
     * @param \Magento\GoogleTagManager\Helper\Data $helper
     * @param \Magento\Framework\Registry $registry
     * @param \Magento\Quote\Model\Quote\Item $item
     * @param $qty
     * @return \Magento\Quote\Model\Quote\Item
     */
    private function setItemForTriggerRemoveEvent(
        \Magento\GoogleTagManager\Helper\Data $helper,
        \Magento\Framework\Registry $registry,
        \Magento\Quote\Model\Quote\item $item,
        $qty
    ) {
        if (!$helper->isTagManagerAvailable()) {
            return $item;
        }

        $configProductId = $item->getProduct()->getId();
        if ($parentItem = $item->getParentItem()) {
            $configProductId = $parentItem->getProduct()->getId();
        }
        $namespace = 'GoogleTagManager_products_to_remove';
        $registry->unregister($namespace);
        $registry->register($namespace, [[
            'sku'   => $item->getSku(),
            'name'  => $item->getName(),
            'price' => $item->getPrice(),
            'qty'   => $qty,
            'category' => $this->bwHelper->getProductAttributeValueByCode($configProductId, 'ga_category'),
            'brand' => $this->bwHelper->getProductAttributeValueByCode($configProductId, 'brand')
        ]]);
    }
}
