<?php
namespace BrittainWynyard\Breadcrumbs\Plugin;
use Magento\Catalog\Api\CategoryRepositoryInterface;
use Magento\Framework\App\Response\RedirectInterface;
use Magento\Store\Model\StoreManagerInterface;
use Magento\UrlRewrite\Model\UrlFinderInterface;
use Magento\UrlRewrite\Service\V1\Data\UrlRewrite;
use Magento\Catalog\Model\ResourceModel\Category\CollectionFactory;

class CatalogHelperPlugin
{
    /**
     * Breadcrumb Path cache
     *
     * @var array
     */
    protected $_categoryPath;

    /**
     * @var CategoryRepositoryInterface
     */
    protected $categoryRepository;

    /**
     * @var RedirectInterface
     */
    protected $redirect;

    /**
     * @var UrlFinderInterface
     */
    protected $urlFinder;
    /**
     * @var StoreManagerInterface
     */
    protected $storeManager;

    /** @var CollectionFactory */
    protected $categoryCollectionFactory;

    /**
     * CatalogHelperPlugin constructor.
     * @param CategoryRepositoryInterface $categoryRepository
     * @param RedirectInterface $redirect
     * @param UrlFinderInterface $urlFinder
     * @param StoreManagerInterface $storeManager
     * @param CollectionFactory $categoryCollectionFactory
     */
    public function __construct(
        CategoryRepositoryInterface $categoryRepository,
        RedirectInterface $redirect,
        UrlFinderInterface $urlFinder,
        StoreManagerInterface $storeManager,
        CollectionFactory $categoryCollectionFactory
    ){
        $this->categoryRepository = $categoryRepository;
        $this->redirect = $redirect;
        $this->urlFinder = $urlFinder;
        $this->storeManager = $storeManager;
        $this->categoryCollectionFactory = $categoryCollectionFactory;
    }
    public function afterGetBreadcrumbPath(\Magento\Catalog\Helper\Data $subject, $result)
    {
        if(count($result) == 1 && isset($result['product']) && $currentProduct = $subject->getProduct()){
            if(!$this->_categoryPath){
                $redirectUrl = $this->redirect->getRedirectUrl();
                if($redirectUrl){
                    $store = $this->storeManager->getStore();
                    $redirectUrl = explode('?', $redirectUrl)[0];
                    $requestPath = substr($redirectUrl, strlen($store->getUrl()));
                    $urlRewrite = $this->urlFinder->findOneByData(
                        [
                            UrlRewrite::REQUEST_PATH => ltrim($requestPath, '/'),
                            UrlRewrite::STORE_ID => $store->getId(),
                        ]
                    );
                    if($urlRewrite && $urlRewrite->getEntityType() == 'category'){
                        $categoryId = $urlRewrite->getEntityId();
                        $category = $this->categoryRepository->get($categoryId);
                        if ($category) {
                            $path = [];
                            $pathInStore = $category->getPathInStore();
                            $pathIds = array_reverse(explode(',', $pathInStore));

                            $categories = $category->getParentCategories();

                            // add category path breadcrumb
                            foreach ($pathIds as $categoryId) {
                                if (isset($categories[$categoryId]) && $categories[$categoryId]->getName()) {
                                    $path['category' . $categoryId] = [
                                        'label' => $categories[$categoryId]->getName(),
                                        'link' => $categories[$categoryId]->getUrl()
                                    ];
                                }
                            }
                            $path['product'] = $result['product'];
                            $this->_categoryPath = $path;
                            return $this->_categoryPath;
                        }
                    }
                }
                $mainCategoryId = $currentProduct->getMainCategory();
                if($mainCategoryId){
                    $mainCategory = $this->categoryRepository->get($mainCategoryId);
                    $catCollection = $this->categoryCollectionFactory->create()
                        ->addAttributeToSelect(['name', 'url'])
                        ->addAttributeToFilter('entity_id', ['in' => $mainCategory->getPathIds()]);
                    foreach ($catCollection as $item) {
                        if($item->getLevel()>1){
                            $path['category' . $item->getId()] = [
                                'label' => $item->getName(),
                                'link' => $item->getUrl()
                            ];
                        }
                    }

                    $path['product'] = $result['product'];
                    $this->_categoryPath = $path;
                    return $this->_categoryPath;
                }
            } else
                return $this->_categoryPath;
        }
        return $result;
    }
}
