<?php


namespace BrittainWynyard\BazaarVoice\Plugin;


use Bazaarvoice\Connector\Model\StringFormatter;

class StringFormatterPlugin
{
    protected $helper;

    public function __construct(
        \BrittainWynyard\BazaarVoice\Helper\Data $helper
    ) {
        $this->helper = $helper;
    }

    /**
     * @param \Bazaarvoice\Connector\Model\StringFormatter $subject
     * @param callable $proceed
     * @param mixed $product
     */
    public function aroundGetFormattedProductSku(\Bazaarvoice\Connector\Model\StringFormatter $subject, callable $proceed, $product)
    {
        if (is_object($product)) {
            $rawProductId = $this->helper->getProductId($product);
        } else {
            $rawProductId = $product;
        }

        return $subject->replaceIllegalCharacters($rawProductId);
    }
}
