<?php


namespace BrittainWynyard\BazaarVoice\Plugin;


use Bazaarvoice\Connector\Model\Dcc\CatalogData\CatalogProductBuilder;

class CatalogProductBuilderPlugin
{


    /**
     * @param \Bazaarvoice\Connector\Model\Dcc\CatalogData\CatalogProductBuilder $subject
     * @param callable $proceed
     * @param Product $product
     * @param Product|null $parentProduct
     */
    public function aroundBuild(\Bazaarvoice\Connector\Model\Dcc\CatalogData\CatalogProductBuilder $subject, callable $proceed, $product, $parentProduct = null)
    {
        $dccCatalogProduct =  $proceed($product, $parentProduct);

        //for some reason style_code and colour_code isn't accessible on simple products within the configurable
        //where supplier_code is, I believe this is related to attribute config but haven't had time to diagnose
        //this is an interim solution, it is not ideal as it results in a few additional db loads but it's not the end
        //of the world as the page will be cached anyway, ideally we would remove the need for this
        if ($product->getTypeId() == 'simple' && $product->getData('style_code') == '' && $product->getData('colour_code') == '') {
            $product = $product->load($product->getId());
        }

        //if style_code and colour_code isn't set to show in product list, this won't be visible, fall back to sku in this case
        if ($product->getData('style_code') && $product->getData('colour_code')) {
            $this->updateDCC($dccCatalogProduct, $product, $parentProduct);
        }

        return $dccCatalogProduct;
    }


    //modifies existing dcc feed with Asics specific customisations
    protected function updateDcc($dccCatalogProduct, $product, $parentProduct)
    {
        $productId = $product->getData('style_code').'-'.$product->getData('colour_code');
        $configurableProductId = $productId;

        if ($product->getTypeId() == 'simple') {
            $productId .= '-'.$product->getData('size');
        }

        $dccCatalogProduct->setProductId($productId);

        $families = [];
        for($f=0;$f < count($dccCatalogProduct['families']); $f++) {
            $family = $dccCatalogProduct['families'][$f];

            if ($product->getTypeId() == 'simple' && $parentProduct && $family['id'] == $parentProduct->getSku()) {
                $family['id'] = $configurableProductId;
            } else if ($product->getTypeId() == 'configurable' && $family['id'] == $product->getSku()) {
                $family['id'] = $configurableProductId;
            } else {
                $family['id'] .= '-family';
            }

            for($m=0;$m < count($dccCatalogProduct['families'][$f]['members']); $m++) {
                $family['members'][$m] = $productId;
            }
            $families[$f] = $family;
        }

        $dccCatalogProduct['families'] = $families;

        return $dccCatalogProduct;
    }



}
