<?php

namespace BrittainWynyard\BazaarVoice\Helper;

use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Framework\App\Helper\Context;
use Magento\Catalog\Model\Product;

class Data extends AbstractHelper
{
    public function getProductId($product)
    {
        $productIdPattern = $this->getBvProductIdPattern();
        preg_match_all('/\{([a-zA-Z0-9_]+)\}/', $productIdPattern, $matches);

        if (empty($matches[1])) {
            $productId = $product->getData('style_code') . '-' . $product->getData('colour_code');

            if ($product->getTypeId() == 'simple') {
                $productId .= '-' . $product->getData('size');
            }
        } else {
            $productId = $productIdPattern;
            foreach ($matches[1] as $attributeCode) {
                if ($product->hasData($attributeCode)) {
                    $value = $product->getData($attributeCode);
                } else {
                    $value = '';
                }
                $productId = str_replace('{' . $attributeCode . '}', $value, $productId);
            }
        }

        return $productId;
    }

    /**
     * @return mixed
     */
    public function getBvProductIdPattern()
    {
        return $this->scopeConfig->getValue('review/configuration/bv_product_id_pattern');
    }

}
