<?php
namespace Asics\Analytics\Helper;

use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Framework\App\Helper\Context;
use Magento\Store\Model\ScopeInterface;
use Magento\Store\Model\StoreManagerInterface;

class Data extends AbstractHelper
{
    const ASICS_ANALYTICS_EXCLUDE_CONTROLLERS = 'asics_analytics/general/controller';

    /**
     * @var StoreManagerInterface
     */
    public $storeManager;

    /**
     * Data constructor.
     *
     * @param StoreManagerInterface $storeManager
     * @param Context $context
     */
    public function __construct(
        StoreManagerInterface $storeManager,
        Context $context
    ) {
        $this->storeManager = $storeManager;
        parent::__construct($context);
    }

    /**
     * @return bool
     */
    public function isEnabled()
    {
        $module = $this->_request->getModuleName();
        $controller = $this->_request->getControllerName();
        $action = $this->_request->getActionName();

        //check controller
        if ($this->regexMatchSimple(
            $this->scopeConfig->getValue(self::ASICS_ANALYTICS_EXCLUDE_CONTROLLERS, ScopeInterface::SCOPE_STORE),
            "{$module}_{$controller}_{$action}",
            1
        )) {
            return false;
        }

        return true;
    }

    /**
     * @param $regex
     * @param $matchTerm
     * @param $type
     * @return bool
     */
    public function regexMatchSimple($regex, $matchTerm, $type)
    {

        if (!$regex) {
            return false;
        }

        $rules = unserialize($regex);

        if (empty($rules)) {
            return false;
        }

        foreach ($rules as $rule) {
            $regex = trim($rule['asics_analytics'], '#');
            if ($type == 1) {
                $regexs = explode('_', $regex);
                switch ($this->countArray($regexs)) {
                    case 1:
                        $regex = $regex.'_index_index';
                        break;
                    case 2:
                        $regex = $regex.'_index';
                        break;
                    default:
                        break;
                }
            }

            $regexp = '#' . $regex . '#';
            if (preg_match($regexp, $matchTerm)) {
                return true;
            }
        }
        return false;
    }

    /**
     * @param $array
     * @return int
     */
    public function countArray($array)
    {
        return count($array);
    }
}
