# Brittain Wynyard Asics M2 project

Used "Overdose base-theme": https://bitbucket.org/overdosedigital/theme-base/

## Installation

**Local configs**  
Copy configs from `app/etc/env.sample` to the `app/etc/env.php`: https://i.imgur.com/6si2TnP.png for local development.

To get **media**:  
`rsync -az --exclude 'analytics' --exclude 'captcha' --exclude 'catalog/product/cache' --exclude 'catalog/tmp' --exclude 'import' --exclude 'magefan_blog/tmp' --exclude 'tmp' 1.ent-v7jcmstnrgvqq-production-vohbr3y@ssh.ap-3.magento.cloud:pub/media/ pub/media/`

To get the **database** use https://projects.magedirect.co/

## Additionally:
Coming soon

**Attributes**  
Coming soon

**Category**  
Coming soon

**Product**  
Coming soon  
Module Overdose product banners

**Search**  
The search on store done with Klevu, search & product discovery platform for M2.  
Stores > Settings > Configuration > Klevu > Search Configuration

**Cart**  
Coming soon

**Checkout**  
Coming soon

**Customer accounts**  
Customers Log in with OneASICS https://id.asics.com/  
Create an account with OneASICS.

**CMS pages**  
Coming soon

**PageBuilder**  
Custom PageBuilder elements:
- Asics Banner
- Large Category Tiles
- Med Category Tiles
- Small Category Tiles
- Tiny Category Tiles
- Menu Image Group
- Large Article Tile
- Small Article Tiles
- Accordion

**Media**  
Currently all assets & images are served via www.asics.com domain name, which goes via Akamai. This prevents the Fastly CDN from optimising the images and serving next-gen image formats (WebP).

## JS Optimizations - Overdose_LazyLoadJavascript  
Bundling not actual after release of http2.  
Post with detailed tests: https://www.mageworx.com/blog/magento-2-speed-optimization-research-proves-default-functionality-is-enough
- Check that minification is enabled (JS/CSS) in the config.php file ("merge js" better disable)
- Asics already use "Lazy load for JS": 
https://bitbucket.org/overdosedigital/brittain-wynyard-asics-m2/src/production/app/code/Overdose/LazyLoadJavascript/

**Overdose_LazyLoadJavascript**

Non-critical scripts loads with delay 5000ms after `DOMContentLoaded`.

Init: app/code/Overdose/LazyLoadJavascript/View/frontend/templates/js/jslazyloading.phtml

Render Controller: app/code/Overdose/LazyLoadJavascript/Plugin/ControllerRenderResultAfter.php  

There are three sections in render controller with three script types (replacing type by keyword):  
- **text/delayscript**: used for inline scripts and changes type in code from `<script>` and `<script type="text/javascript">` to `<script type="text/delayscript">`
- **text/delayscriptsource**: used for external scripts with src and changes type in code from `<script>` and `<script type="text/javascript">` to `<script type="text/delayscriptsource">`
- **loaderscripts**: used for non-lazy scripts and changes type in code from `<script>` and `<script type="text/javascript">` to `<script type="loaderscripts">`

**Warning notes about writing new keywords for replacement script type in controller:**  

- Use script keywords in lowercase.
- Do not touch type of "// Load initial js bundle", it should be just <script>
- Your keyword should not change script type for <script type="text/x-magento-init">
- Your keyword should not change script type for <script type="application/ld+json">

