<?php
/**
 * Anowave Magento 2 Google Tag Manager Enhanced Ecommerce (UA) Tracking
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Anowave license that is
 * available through the world-wide-web at this URL:
 * https://www.anowave.com/license-agreement/
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category 	Anowave
 * @package 	Anowave_Ec
 * @copyright 	Copyright (c) 2023 Anowave (https://www.anowave.com/)
 * @license  	https://www.anowave.com/license-agreement/
 */

namespace Anowave\Ec\Observer\Facebook;

use Magento\Framework\Event\Observer as EventObserver;
use Anowave\Ec\Observer\Facebook;

class Checkout extends Facebook
{
    public function execute(EventObserver $observer)
    {
        $checkout = $observer->getTransport()->getCheckout();

        /**
         * Content ids array 
         * 
         * @var array $content_ids
         */
        $content_ids = [];
        
        foreach ($checkout['payload']['ecommerce']['items'] as $entity)
        {
            $content_ids[] = $entity['item_id'];
        }

        $this->helper->getFacebookConversionsApi()->trackInitiateCheckout($content_ids, $checkout['payload']['currency'], $checkout['total']);
    }
}